import { Button } from "@/components/ui/button";
import { Phone, MapPin, Clock, MessageCircle } from "lucide-react";

export const ContactSection = () => {
  const phoneNumber = "07045064559";
  const whatsappLink = `https://wa.me/234${phoneNumber.slice(1)}?text=Hello,%20I%20would%20like%20to%20make%20a%20reservation%20at%20Graziella%20Hotels%20%26%20Suites.`;
  const mapEmbedUrl = "https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3972.123456789!2d7.0!3d5.5!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x0!2sGXWG%2BPP%20Ogbaku!5e0!3m2!1sen!2sng!4v1234567890";

  return (
    <section id="contact" className="py-20 bg-card">
      <div className="container mx-auto px-4">
        <div className="max-w-6xl mx-auto">
          <div className="text-center max-w-2xl mx-auto mb-12">
            <span className="text-gold font-medium tracking-widest uppercase text-sm">
              Get in Touch
            </span>
            <h2 className="font-serif text-3xl md:text-4xl lg:text-5xl font-bold text-foreground mt-2 mb-4">
              Contact Us
            </h2>
            <p className="text-muted-foreground text-lg">
              Ready to book your stay? Contact us today for reservations and inquiries.
            </p>
          </div>

          <div className="grid lg:grid-cols-2 gap-8">
            {/* Contact Info */}
            <div className="space-y-6">
              {/* Contact Cards */}
              <div className="bg-background p-6 rounded-2xl">
                <div className="flex items-start gap-4">
                  <div className="w-12 h-12 bg-primary/10 rounded-full flex items-center justify-center flex-shrink-0">
                    <Phone className="w-6 h-6 text-primary" />
                  </div>
                  <div>
                    <h3 className="font-semibold text-foreground mb-1">Phone</h3>
                    <a
                      href={`tel:${phoneNumber}`}
                      className="text-gold text-lg font-medium hover:underline"
                    >
                      0704 506 4559
                    </a>
                    <p className="text-muted-foreground text-sm mt-1">
                      Available 24 hours for reservations
                    </p>
                  </div>
                </div>
              </div>

              <div className="bg-background p-6 rounded-2xl">
                <div className="flex items-start gap-4">
                  <div className="w-12 h-12 bg-primary/10 rounded-full flex items-center justify-center flex-shrink-0">
                    <MapPin className="w-6 h-6 text-primary" />
                  </div>
                  <div>
                    <h3 className="font-semibold text-foreground mb-1">Address</h3>
                    <p className="text-muted-foreground">
                      KLM 7, Owerri – Onitsha Road,<br />
                      Orogwe, Ogbaku,<br />
                      Imo State, Nigeria
                    </p>
                    <p className="text-gold text-sm mt-2">
                      Plus Code: GXWG+PP Ogbaku
                    </p>
                  </div>
                </div>
              </div>

              <div className="bg-background p-6 rounded-2xl">
                <div className="flex items-start gap-4">
                  <div className="w-12 h-12 bg-primary/10 rounded-full flex items-center justify-center flex-shrink-0">
                    <Clock className="w-6 h-6 text-primary" />
                  </div>
                  <div>
                    <h3 className="font-semibold text-foreground mb-1">Hours</h3>
                    <p className="text-muted-foreground">
                      Check-in: 2:00 PM<br />
                      Check-out: 12:00 Noon
                    </p>
                    <p className="text-muted-foreground text-sm mt-1">
                      Front desk available 24/7
                    </p>
                  </div>
                </div>
              </div>

              {/* CTA Buttons */}
              <div className="flex flex-col sm:flex-row gap-4 pt-4">
                <a href={`tel:${phoneNumber}`} className="flex-1">
                  <Button className="w-full" size="xl">
                    <Phone className="w-5 h-5" />
                    Call Now
                  </Button>
                </a>
                <a href={whatsappLink} target="_blank" rel="noopener noreferrer" className="flex-1">
                  <Button variant="whatsapp" className="w-full" size="xl">
                    <MessageCircle className="w-5 h-5" />
                    WhatsApp
                  </Button>
                </a>
              </div>
            </div>

            {/* Map */}
            <div className="h-full min-h-[400px] rounded-2xl overflow-hidden shadow-card">
              <iframe
                src={mapEmbedUrl}
                width="100%"
                height="100%"
                style={{ border: 0, minHeight: "400px" }}
                allowFullScreen
                loading="lazy"
                referrerPolicy="no-referrer-when-downgrade"
                title="Graziella Hotels & Suites Location"
                className="w-full h-full"
              />
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};
